using System;
using System.Collections.Generic;

using AntMe.English;

// Add your own name behind AntMe.Player
namespace AntMe.Player.LeslieLamport
{

	// It is necessary to give a name to your colony. Please also add your first and last name
	[Player(ColonyName = "myUltimateDistributedSystem2015Ants",
        FirstName = "Leslie",
        LastName = "Lamport"
	)]

	//  Here different casts can be defined.
	[Caste(Name = "Standard",
           AttackModificator = 0,
           EnergyModificator = 0,
           LoadModificator = 0,
           RangeModificator = 0,
           RotationSpeedModificator = 0,
           SpeedModificator = 0,
           ViewRangeModificator = 0
	)]

    public class MyAnt : BaseAnt
    {

        #region Caste

        /// <summary>
        /// Determines the caste of a new ant
        /// </summary>
        /// <param name="count">The number of existing ants per caste</param>
        /// <returns>The name of the cast of the new ant spawned next.</returns>
        public override string ChooseType(Dictionary<string, int> count)
        {
            if (count["Standard"] > 9 )
                return "Standard";
            else return "Standard";
        }

        #endregion

        #region Movement

        /// <summary>
		/// Is called whenever the ant has nothing to do
		/// </summary>
		public override void Waits()
		{
		}

		/// <summary>
		/// Is called once when the ant has exceeded one third of its maximal movement range
		/// </summary>
		public override void BecomesTired()
		{
		}

		#endregion

		#region Food

		/// <summary>
		/// Is called continuously whenever the ant sees at least one pile of sugar
		/// </summary>
		/// <param name="sugar">The nearest pile of sugar.</param>
		public override void Spots(Sugar sugar)
		{
		}

		/// <summary>
        /// Is called continuously whenever the ant sees at least one fruit
		/// </summary>
		/// <param name="fruit">Das nchstgelegene Obststck.</param>
		public override void Spots(Fruit fruit)
		{
		}

        

		/// <summary>
		/// Is called once if the ant has a pile of sugar as target and arrives at the pile.
		/// </summary>
		/// <param name="sugar">The pile of sugar</param>
		public override void TargetReached(Sugar sugar)
		{
 		}

		/// <summary>
        /// Is called once if the ant has a fruit as target and arrives at the fruit.
		/// </summary>
		/// <param name="fruit">The fruit.</param>
        public override void TargetReached(Fruit fruit)
		{
		}

		#endregion

		#region Communication

		/// <summary>
		/// Is called once if the ant smells a marker from the own colony. Markers smelled once are not smelled again.
		/// </summary>
		/// <param name="marker">Die nchste neue Markierung.</param>
		public override void SmellsFriend(Marker marker)
		{
		}

		/// <summary>
		/// Is called repeatedly whenever the ant sees at least one ant from its colony.
		/// </summary>
		/// <param name="ant">The nearest ant from the same colony</param>
		public override void SpotsFriend(Ant ant)
		{
		}


		#endregion

		#region Fighting

		/// <summary>
		/// Is called repeatedly whenever the ant sees at least one bug.
		/// </summary>
		/// <param name="bug">The nearest bug.</param>
		public override void SpotsEnemy(Bug bug)
		{
		}

		/// <summary>
		/// Is called repeatedly if the ant is attacked by a bug.
		/// </summary>
		/// <param name="bug">The attacking bug.</param>
		public override void UnderAttack(Bug bug)
		{
		}

		#endregion

		#region Other

		/// <summary>
		/// Is called once if the ant dies.
		/// </summary>
		/// <param name="kindofdeath">Why the ant died</param>
		public override void HasDied(KindOfDeath kindofdeath)
		{
		}

		/// <summary>
		/// Is called in every tick.
		/// </summary>
		public override void Tick()
		{
		}

		#endregion
		 
	}
}