import java.rmi.*;
import java.rmi.registry.LocateRegistry;
import java.security.KeyPair;
import java.security.KeyPairGenerator;

import javax.crypto.Cipher;

public class DecoderClient {
	
	public static void main (String[] args) {
		DecoderInterface di;
		try {
			System.setSecurityManager(new SecurityManager());
			KeyPairGenerator keyGen = KeyPairGenerator.getInstance("RSA");
			System.out.println("Decode client started");
		      
			keyGen.initialize(1024);
		    KeyPair key = keyGen.generateKeyPair();
		    
		    byte[] cipherText = null;
		    // get an RSA cipher object and print the provider
		    final Cipher cipher = Cipher.getInstance("RSA");
		    // encrypt the plain text using the public key
		    cipher.init(Cipher.ENCRYPT_MODE, key.getPrivate());
		    cipherText = cipher.doFinal("thestring".getBytes());
			
			di = (DecoderInterface)Naming.lookup("rmi://localhost/aDecoder");
			di.decode(key.getPublic(), cipherText);
			}catch (Exception e) {
			System.out.println(e);
		}
	}
}