import java.net.*;
import java.util.ArrayList;
import java.io.*;

public class Server {

	static ArrayList<Socket> clients = new ArrayList<Socket>();

	// args: port
	public static void main(String args[]) {
		try {
			int port = Integer.parseInt(args[0]);
			ServerSocket listenSocket = new ServerSocket(port);

			System.out.println("Server listening to port " + port);

			while (true) {
				Socket client = listenSocket.accept();
				System.out.println("New connection by client " + client.getInetAddress());
				Connection c = new Connection(client, clients);
				clients.add(client);
			}

		} catch (IOException e) {
			System.err.println("Listen " + e.getMessage());
		}
	}
}

class Connection extends Thread {
	DataInputStream in;
	DataOutputStream out;

	Socket client;
	ArrayList<Socket> clients;

	public Connection(Socket client, ArrayList<Socket> clients) {
		this.client = client;
		this.clients = clients;

		try {
			in = new DataInputStream(client.getInputStream());
			out = new DataOutputStream(client.getOutputStream());
			this.start();
		} catch (IOException e) {
			System.err.println("Connection " + e.getMessage());
		}
	}

	public void run() {
		String data;
		try {
			while (true) {
				if (in.available() > 0) {

					data = in.readUTF();
					System.out.println(data + "	" + client.getInetAddress() + ":" + client.getPort());

					DataOutputStream out;
					for (Socket c : clients) {
						out = new DataOutputStream(c.getOutputStream());
						out.writeUTF(data);
					}

				}
			}
		} catch (EOFException e) {
			System.err.println("EOF: " + e.getMessage());
		} catch (IOException e) {
			System.err.println("IO: " + e.getMessage());
		} finally {
			try {
				client.close();
			} catch (IOException e) {
				System.err.println("Socket: " + e.getMessage());
			}
		}
	}
}
