public class BankingSync {

    public static void main(String args[]) {

	Account acc = new Account(100);

	Thread john = new Thread(new Clerk("John", 50, acc));
	Thread jim  = new Thread(new Clerk("Jim", 100, acc));

	john.start();
	jim.start();
    }
}


class Account {

    int balance;

    public Account (int balance) {
	this.balance = balance;
    }

    public int getBalance(Clerk c) {
	System.out.format("%s gets the balance: Current balance is %d%n", c.name, balance);
	return balance;
    }

    public void setBalance(Clerk c, int newBalance) {
	System.out.format("%s sets the balance: Old balance is %d%n", c.name, balance);
	balance = newBalance;
	System.out.format("%s sets the balance: New balance is %d%n", c.name, balance);
    }

    public synchronized void updateBalance(Clerk c, int deltaBalance) {
	System.out.format("%s updates the balance: Old balance is %d%n", c.name, balance);
	balance = balance + deltaBalance;
	System.out.format("%s updates the balance: New balance is %d%n", c.name, balance);
    }

	
}


class Clerk implements Runnable{

    String name;
    int amount;
    Account acc;

    public Clerk (String name, int amount, Account acc) {
	this.name = name;
	this.amount = amount;
	this.acc = acc;
    }

    public void run() {
	acc.updateBalance(this, amount);
    }

}
	
