/* 
 This class models a bank where two clerks, John and Jim, are
   are transferring money between two accounts.

   Each clerk is modeled by a thread. 

   Bank accounts can be accessed by an update and a transfer method.
   
   The class illustrates how a deadlock can be avoided when the Threads
   serialize the access to resources.

 */

public class BankingSerial {

    public static void main(String args[]) {

	Account acc1 = new Account(1,200);
	Account acc2 = new Account(2,300);

	Thread john = new Thread(new Clerk("John", 50, acc1, acc2));
	Thread jim  = new Thread(new Clerk("Jim", 70, acc2, acc1));

	john.start();
	jim.start();
    }
}


class Account {

    int number;
    int balance;

    public Account (int number, int balance) {
	this.number = number;
	this.balance = balance;
    }

    public int getNumber() {
	return number;
    }


    public void updateBalance(Clerk c, int deltaBalance) {
	System.out.format("%s updates the balance of account %d: Old balance is %d%n", c.name, this.number, this.balance);
	balance = balance + deltaBalance;
	System.out.format("%s updates the balance of account %d: New balance is %d%n", c.name, this.number, this.balance);
    }


    public void transfer(Clerk c, int amount, Account toAccount) {

	System.out.format("%s transfers %d Quid from Account %d to Account %d%n", 
			  c.name, amount, number, toAccount.number);

	if (this.getNumber() <= toAccount.getNumber()) {
	    synchronized(this) {
		synchronized(toAccount) {

		    this.updateBalance(c, -amount);
		    toAccount.updateBalance(c, amount);

		}
	    }
	} else {
	    synchronized(toAccount) {
		synchronized(this) {

		    this.updateBalance(c, -amount);
		    toAccount.updateBalance(c, amount);

		}
	    }
	};

    }
}


class Clerk implements Runnable{

    String name;
    int amount;
    Account fromAccount, toAccount;

    public Clerk (String name, int amount, Account fromAccount, Account toAccount) {
	this.name = name;
	this.amount = amount;
	this.fromAccount = fromAccount;
	this.toAccount = toAccount;
    }

    public void run() {

	fromAccount.transfer(this, amount, toAccount);
    }
}
	
