/* 
   This class models a bank where two clerks, John and Jim, are
   accessing a bank account to add a certain amount of money to that
   account. John wants to add 50 Quid while Jim wants to add 100 Quid.

   Each clerk is modeled by a thread. 

   Bank accounts can be accessed by a get and a set method. The access
   methods print to standard output what they are currently doing.
   
   The class illustrates what can go wrong when several threads can
   access a resource without coordination.
 */

public class Banking {

    public static void main(String args[]) {

	Account acc = new Account(100);

	Thread john = new Thread(new Clerk("John", 50, acc));
	Thread jim  = new Thread(new Clerk("Jim", 100, acc));

	john.start();
	jim.start();
    }
}


class Account {

    int balance;

    public Account (int balance) {
	this.balance = balance;
    }

    public int getBalance(Clerk c) {
	System.out.format("%s gets the balance: Current balance is %d%n", c.name, balance);
	return balance;
    }

    public void setBalance(Clerk c, int newBalance) {
	System.out.format("%s sets the balance: Old balance is %d%n", c.name, balance);
	balance = newBalance;
	System.out.format("%s sets the balance: New balance is %d%n", c.name, balance);
    }

}


class Clerk implements Runnable{

    String name;
    int amount;
    Account acc;

    public Clerk (String name, int amount, Account acc) {
	this.name = name;
	this.amount = amount;
	this.acc = acc;
    }

    public void run() {

	int balance, newBalance;

	balance = acc.getBalance(this);
	
	newBalance = balance + amount;

	acc.setBalance(this, newBalance);
    }
}
	
