/* 
   This class models a bank where two clerks, John and Jim, are
   are transferring money between two accounts.

   Each clerk is modeled by a thread. 

   Bank accounts can be accessed by an update and a transfer method.
   
   The class illustrates how a deadlock can occur when each of two Threads
   attempts to access resources that the other one is holding.

   For the example to always work it is crucial that a clerk takes a 
   short nap (i.e., is put to sleep for a fraction of a second) after
   the first update. In this way, the Java machine hands control over to the
   next thread.

 */

public class BankingDeadlock {

    public static void main(String args[]) {

	Account acc1 = new Account(1,200);
	Account acc2 = new Account(2,300);

	Thread john = new Thread(new Clerk("John", 50, acc1, acc2));
	Thread jim  = new Thread(new Clerk("Jim", 70, acc2, acc1));

	john.start();
	jim.start();
    }
}


class Account {

    int number;
    int balance;

    public Account (int number, int balance) {
	this.number = number;
	this.balance = balance;
    }

    public int getNumber() {
	return number;
    }


    public synchronized void updateBalance(Clerk c, int deltaBalance) {
	System.out.format("%s updates the balance: Old balance is %d%n", c.name, balance);
	balance = balance + deltaBalance;
	System.out.format("%s updates the balance: New balance is %d%n", c.name, balance);
    }

    public synchronized void transfer(Clerk c, int amount, Account toAccount) {

	System.out.format("%s transfers %d Quid from Account %d to Account %d%n", 
			  c.name, amount, number, toAccount.number);

	this.updateBalance(c, -amount);

	try{
	    Thread.sleep(0,1);}
	catch (InterruptedException e) {};

	toAccount.updateBalance(c, amount);

    }

}


class Clerk implements Runnable{

    String name;
    int amount;
    Account fromAccount, toAccount;

    public Clerk (String name, int amount, Account fromAccount, Account toAccount) {
	this.name = name;
	this.amount = amount;
	this.fromAccount = fromAccount;
	this.toAccount = toAccount;
    }

    public void run() {

	fromAccount.transfer(this, amount, toAccount);
    }
}
	
