package server;

import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

import client.ClientCommInterface;

public class ServerCommHandler extends UnicastRemoteObject implements ServerCommInterface {

	private static final long serialVersionUID = -753493834709721813L;
	HashMap<String, Integer> myScoreMap;
	private Set<ClientCommInterface> myClients;
	String currentSolution = null;
	byte[] currentHash = null;
	boolean isSolved = false;
	MessageDigest md = null;
	List<String> oldProblems;
	int currentProblem;
	
	public ServerCommHandler(HashMap<String, Integer> sm) throws RemoteException, NoSuchAlgorithmException {
		myScoreMap = sm;
		myClients = ConcurrentHashMap.newKeySet();//new HashSet<ClientCommInterface>();
		oldProblems = new LinkedList<String>();
		md = MessageDigest.getInstance("MD5");
	}

	@Override
	public void register(String name, ClientCommInterface cc) throws Exception {
		System.out.println("  Registering team " + name);
		if (!myScoreMap.containsKey(name))
			myScoreMap.put(name,0);
		myClients.add(cc);
		cc.publishProblem(currentHash, Server.PROBLEMSIZE);
		
	}

	public void createAndPublishProblem(int run) throws Exception {
		isSolved = false;
		currentSolution = generateRandomString(Server.PROBLEMSIZE);
		currentHash = md.digest(currentSolution.getBytes());
		for (ClientCommInterface cc : myClients) {
			try {cc.publishProblem(currentHash, Server.PROBLEMSIZE);}
			catch (Exception e) {System.out.println("  Could not print to some client");}
		}
		System.out.println("  Created and published Problem " + run + ": " + currentSolution);
		currentProblem = run;
	}

	private String generateRandomString(int max) {
		Integer random = (int)Math.round(Math.random()*max);
		return random.toString();
	}

	@Override
	public void submitSolution(String name, String sol) {
		byte[] solHash = md.digest(sol.getBytes());
		if (Arrays.equals(solHash, currentHash)) {
			isSolved = true;
			oldProblems.add(sol);
			currentHash = null; // So that no client can submit this solution a second time and get points again
			myScoreMap.put(name, myScoreMap.get(name)+1) ;
			System.out.println("  Team " + name + " solved Problem " + currentProblem + " correctly");
		}
		else {
			if (isOldSolution(sol))
				System.out.println("  Team " + name + " submitted a correct solution for Problem " + currentProblem + " too late");
			else {
				System.out.println("  Team " + name + " submitted an incorrect solution to Problem " + currentProblem);
				myScoreMap.put(name, myScoreMap.get(name)-1);
			}
		}
	}

	private boolean isOldSolution(String sol) {
		for (String s : oldProblems)
			if (s.equals(sol))
				return true;
		return false;
	}

	public boolean isSolved() {
		return isSolved;
	}

}
