package client;
import java.rmi.Naming;
import java.util.Random;

import server.SortInterface;


public class SortCombiner {

	static final int MAX = 999999;
	static Integer[][] segments;
	
	/**
	 * First argument: Number of elements to sort
	 * Remaining arguments: IP addresses of machines used for the sorting (can also include the own machine)
	 */
	public static void main(String[] args) throws InterruptedException {
		int n = Integer.parseInt(args[0]);

		int sortProviderNr = args.length - 1; // Number of peers used
		String[] addresses = new String[sortProviderNr];
		System.out.println("Sorting " + n + " random integers using " + sortProviderNr + " machines.");

		Long start = System.currentTimeMillis();
		
		System.setSecurityManager(new SecurityManager());
		
		int[] toSort = newRandomArray(n);
		segments = new Integer[sortProviderNr][n/sortProviderNr];
		SorterThread[] sorterThreads = new SorterThread[sortProviderNr];
		
		for (int i=0; i<sortProviderNr; i++) {
			addresses[i] = args[i+1];
			int subArrayStart = (int)((n/(float)sortProviderNr)*i);
			copyArrayManual(toSort, subArrayStart, segments[i], 0, n/sortProviderNr);

			// Start a new thread for each segment
			try {
				String objectname = "rmi://" + addresses[i] + "/sorter";
				System.out.println("Connecting to " + objectname + " for sorting " + segments[i].length + " numbers");
				sorterThreads[i] = new SorterThread(objectname, segments[i], i);
				System.out.println("Starting sorting for Segment " + i);
				sorterThreads[i].start();
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
		
		// Now wait until all threads are finished, i.e., have obtained results
		for (SorterThread t: sorterThreads)
			t.join();
		
		// Merge the results
		System.out.println("Starting merging results..");
		int[] result = new int[n];
		int[] counter = new int[sortProviderNr];
		for (int j=0; j<n-1; j++) {
			int minElement = -1;
			int minSegment = -1;
			for (int k=0; k<sortProviderNr; k++) {
				if (counter[k]<segments[0].length && (segments[k][counter[k]]<minElement || minElement==-1)) {
					minElement = segments[k][counter[k]];
					minSegment = k;
				}
			}
			result[j] = minElement;
			counter[minSegment]++;
		}
		
		System.out.println("\nSorting " + n + " numbers took " + (System.currentTimeMillis()-start) + " millis");
	}

	private static void copyArrayManual(int[] input, int start, Integer[] output, int start2, int length) {
		for (int i=0; i<length; i++)
			output[i] = new Integer(input[start+i]);
	}

	private static int[] newRandomArray(int n) {
		Random rn = new Random();
		int[] a = new int[n];
		for (int i=0; i<n; i++)
			a[i] = rn.nextInt(MAX);
		return a;
	}
}
