package server;
import java.net.InetAddress;
import java.rmi.*;
import java.rmi.registry.LocateRegistry;
     
public class SortProvider {
	
	/**
	 * @param args[0] IP address on which to listen for sorting requests
	 */
    public static void main (String[] args) {
    	System.out.println("Starting up sortprovider...");
    	try {
    		System.setSecurityManager(new SecurityManager());
    		System.setProperty("java.rmi.server.hostname",args[0]);
    		LocateRegistry.getRegistry();
    		Sorter p = new Sorter();
    		Naming.rebind("sorter", p);
    		System.out.println("Sort provider is ready on " + InetAddress.getLocalHost());
    	}catch (Exception e) {
    		System.out.println("Sort provider failed: " + e);
    	}
    }
}