package datalinklayer;

public class Frame {
	
	String data;		// the actual data
	boolean parityBit;  // a parity bit
	boolean ackBit;     // indicator whether the frame is meant as acknowledgement
	int seqNr;          // the sequence number
	
	/**
	 * Creates a frame
	 * @param n: the sequence number
	 * @param d: the data
	 * @param a: indicates whether the frame is an acknowledgment
	 */
	public Frame(int n, String d, boolean a) {
		seqNr = n;
		data = d;
		if (data!=null) { 
			parityBit = calculateParity();
		}
		ackBit = a;
	}

	/**
	 * Calculates the parity of a message, based on bit arithmetics
	 * @return the value of the parity bit
	 */
	boolean calculateParity() {
		boolean result = false;
		for (Byte b : data.getBytes()) {
			for (int i=0; i<8; i++) {
				// Bitwise XOR
				if ((b & (byte)Math.pow(2, i))!=0) result = result ^ true;
			}
		}
		return result;
	}

	/**
	 * Takes a frame and replaces one random byte in the message with a random new byte. 
	 * @return the garbled frame
	 */
	public Frame createGarbledCopy() {
		String dataCopy;
		if (this.data!=null) dataCopy = new String(this.data);
		else dataCopy = null;
		Frame copy = new Frame(this.seqNr, dataCopy, this.ackBit);
		if (data!=null) {
			int length = copy.data.length();
			int garbledPos = (int)(Math.random()*(length-1));
			String garbledVal = ((Integer)(int)(Math.random()*9)).toString();
			copy.data = data.substring(0,garbledPos) + garbledVal + data.substring(garbledPos+1,data.length());
		}
		return copy;
	}
}
