package datalinklayer;

 /**
  * @author Simon Razniewski, for the course Distributed Systems 2016
  */

public class Simulation {

	// Play with these
	static final int bufferSize = 100; // buffer size for the physical layer in byte
	static final int retransmissionTimeOut = 80; // timeout in milliseconds before retransmitting unacknowledged frames

	// Fixed parameters
	static final int packageSize = 1; // package size in byte
	static final int protocolDelay = 10; // time (in ms) any layer thread sleeps between any two actions
	static final int channelCapacity = 1; // How many packages can be transmitted per channelDelay tick
	static final int channelDelay = 40; // delay (in ms) between the transfer of two messages
	static final double garblingProbability = 0.2; // probability of error in packages
	static final double lossProbability = 0.1; // probability of package loss
	
	// Debug output
	static final boolean SHOWMESSAGE = true; 
	static final boolean SHOWINTERNALS = true; 
	
	// Main method, creates two link layers and their corresponding physical layers, then lets one send a message to the other.
	public static void main(String[] args) {
		PhysicalLayer peer1Phys = new PhysicalLayer();
		PhysicalLayer peer2Phys = new PhysicalLayer();
		peer1Phys.partnerLayer=peer2Phys;
		peer2Phys.partnerLayer=peer1Phys;
		LinkLayer ll1 = new LinkLayer(peer1Phys,"Richard Wesley Hamming (February 11, 1915  January 7, 1998) was an American mathematician whose work had many implications for computer science and telecommunications. His contributions include the Hamming code (which makes use of a Hamming matrix), the Hamming window, Hamming numbers, sphere-packing (or Hamming bound) and the Hamming distance.","Sender");
		LinkLayer ll2 = new LinkLayer(peer2Phys,null,"Receiver");
		peer1Phys.start();
		peer2Phys.start();
		ll1.start();
		ll2.start();
	}

}
