package datalinklayer;

import java.util.LinkedList;
import java.util.concurrent.ConcurrentLinkedQueue;


public class PhysicalLayer extends Thread {
	LinkLayer ll;
	ConcurrentLinkedQueue<Frame> queueOut;
	ConcurrentLinkedQueue<Frame> queueIn;
	PhysicalLayer partnerLayer;

	public PhysicalLayer() {
		queueIn = new ConcurrentLinkedQueue<Frame>();
		queueOut = new ConcurrentLinkedQueue<Frame>();
	}
	
	// Forever: Move messages from the output queue to the input queue of the partner, then sleep a little
	public void run() {
		while (true) {
			// Drop messages if too many
			if (queueOut.size()>Simulation.bufferSize)
				queueOut =  new ConcurrentLinkedQueue<Frame>(new LinkedList<Frame>(queueOut).subList(0, Simulation.bufferSize));
			// Send channelCapacity messages
			for (int i=0; i<Simulation.channelCapacity; i++) {
				if (queueOut.size()>0) {
					Frame transmit = queueOut.poll();
					if (Math.random()<Simulation.garblingProbability) transmit = transmit.createGarbledCopy();
					partnerLayer.queueIn.add(transmit);
				}
			}
			// Sleep a little
			try {Thread.sleep(Simulation.channelDelay+Simulation.protocolDelay);} catch (InterruptedException e) {}
		}
	}
}
